/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpHex.c,v 1.3 1999/12/14 01:04:56 cpeterson Exp $
____________________________________________________________________________*/
#include "pgpPFLConfig.h"
#include <string.h>
#include "pgpHex.h"

	PGPBoolean
pgpIsValidHexChar( char	theChar )
{
	return( (theChar >= '0' && theChar <= '9') ||
		( theChar >= 'a' && theChar <= 'f' ) ||
		( theChar >= 'A' && theChar <= 'F' ) );
}

	PGPByte
pgpHexCharToNibble( char theChar )
{
	if ( theChar >= '0' && theChar <= '9' )
		return( theChar - '0' );
	if ( theChar >= 'a' && theChar <= 'f' )
		return( ( theChar - 'a' ) + 10 );
		
	return( ( theChar - 'A' ) + 10 );
}

	void
pgpBytesToHex(
	PGPByte const *	keyBytes,
	PGPSize			numBytes,
	PGPBoolean		add0x,
	char *			outString )
{
	static const char 	sHexDigits[] = "0123456789ABCDEF";
	char *				curString	= outString;
	static const char	sPrefixStr[] = "0x";
	PGPSize				keyByteIndex;
	
	if ( add0x )
	{
		strcpy( curString, sPrefixStr );
		curString	+= sizeof( sPrefixStr ) - 1;
	}
	
	for( keyByteIndex = 0; keyByteIndex < numBytes; ++keyByteIndex )
	{
		PGPByte	keyByte	= keyBytes[ keyByteIndex ];
		
		/* output high nibble, then low nibble */
		*curString++	= sHexDigits[ ( keyByte >> 4 ) & 0x0F ];
		*curString++	= sHexDigits[ keyByte & 0x0F ];
	}
	
	*curString++	= '\0';
}


/*____________________________________________________________________________
	Convert a stream of hex data into binary data. Since it's just a stream,
	byte order is irrelevant. Returns how many bytes were converted.
____________________________________________________________________________*/
	PGPUInt32
pgpHexToBytes(
	const char *	hex,
	PGPUInt32		numBinaryBytes,
	PGPByte *		buffer )
{
	PGPUInt32		counter;
	const char *	cur;
	PGPByte *		outCur;
	
	/* skip leading "0x", if present */
	if ( hex[ 0 ] == '0' && 
		(( hex[ 1 ] == 'x' ) || ( hex[ 1 ] == 'X' )) )
	{
		hex	+= 2;
	}
		
	counter	= numBinaryBytes;
	cur		= hex;
	outCur	= buffer;
	while ( counter-- != 0 )
	{
		PGPByte		theByte;
		
		if ( ! pgpIsValidHexChar( *cur ) )
			break;
		theByte	= pgpHexCharToNibble( *cur );
		++cur;
		
		if ( ! pgpIsValidHexChar( *cur ) )
		{
			*outCur++ = theByte;
			break;
		}

		theByte <<= 4;
		theByte	|= pgpHexCharToNibble( *cur );
		++cur;
		
		*outCur++	= theByte;
	}

	return outCur - buffer;
}

	PGPUInt32
pgpHexToPGPUInt32( const char *hex )
{
	PGPByte		buffer[ 4 ];
	PGPUInt32	result = 0;
	PGPUInt32	numBytes;
	
	numBytes = pgpHexToBytes( hex, 4, buffer );
	
	if (numBytes > 0)
		result	= buffer[ 0 ];

	if (numBytes > 1)
		result	= ( result << 8 ) | buffer[ 1 ];

	if (numBytes > 2)
		result	= ( result << 8 ) | buffer[ 2 ];

	if (numBytes > 3)
		result	= ( result << 8 ) | buffer[ 3 ];
	
	return( result );
}


	void
pgpPGPUInt32ToHex( 
	const PGPUInt32 number,
	PGPBoolean		add0x,
	char *			outString )
{
	PGPByte		buffer[ 4 ];

	buffer[ 3 ] = number & 0xFF;
	buffer[ 2 ] = (number >> 8) & 0xFF;
	buffer[ 1 ] = (number >> 16) & 0xFF;
	buffer[ 0 ] = (number >> 24) & 0xFF;

	pgpBytesToHex( buffer, sizeof(buffer), add0x, outString );

	return;
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
